<?php

namespace App\Http\Controllers;

use App\Models\SubGenre;
use App\Http\Requests\StoreSubGenreRequest;
use App\Http\Requests\UpdateSubGenreRequest;
use App\Models\Genre;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Models\User;
use DB;
use Hash;
use Illuminate\Support\Arr;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;

class SubGenreController extends Controller
{
    /**
     * Display a listing of the resource.
     */


    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('permission:view-subgenre|create-subgenre|edit-subgenre|delete-subgenre', ['only' => ['index', 'show']]);
        $this->middleware('permission:create-subgenre', ['only' => ['create', 'store']]);
        $this->middleware('permission:edit-subgenre', ['only' => ['edit', 'update']]);
        $this->middleware('permission:delete-subgenre', ['only' => ['destroy']]);
    }


    public function index(Request $request)
    {
        user_logs();
        $genres = Genre::getGenres();
        $data = SubGenre::latest()->paginate(itemsPerPage());
        return view('subgenres.index', compact('data', 'genres'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        user_logs();
        $genres = Genre::getGenres();
        return view('subgenres.create', compact('genres'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreSubGenreRequest $request)
    {
        user_logs();
        $input = $request->all();
        SubGenre::create($input);

        return redirect()->route('subgenre.index')->with([
            'message' => 'Sub Genre created successfully',
            'alert-type' => 'success'
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(SubGenre $subGenre)
    {
        user_logs();
        $genre = SubGenre::find($subGenre->id);
        return view('subgenres.show', compact('genre'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(SubGenre $subGenre,$id)
    { 
        user_logs();
        $genres = Genre::getGenres();
        $subgenre = SubGenre::find($id);
        return view('subgenres.edit', compact('subgenre', 'genres'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateSubGenreRequest $request, SubGenre $subGenre,$id)
    {
        user_logs();
        $input = $request->all();
        $genre = SubGenre::find($id);
        $genre->update($input);
        return redirect()->route('subgenre.index')->with([
            'message' => 'Sub Genre updated successfully',
            'alert-type' => 'success'
        ]);
    }

    public function statusUpdate(Request $request)
    {
        $response = null;
        $input = $request->all();
        $genreId = $input['genreId'];
        $genre = SubGenre::find($genreId);

        if ($genre->status) {
            $genre->status = SubGenre::DISABLED;
            $response = 'disabledGenre';
        } else {
            $genre->status = SubGenre::ACTIVE;
            $response = 'activeGenre';
        }
        $genre->save();
        return $response;
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(SubGenre $subGenre)
    {
        user_logs();
        SubGenre::find($subGenre->id)->delete();
        return redirect()->route('subgenre.index')->with([
            'message' => 'Sub Genre deleted successfully',
            'alert-type' => 'success'
        ]);
    }
}
